/*
 * Decompiled with CFR 0.152.
 */
package com.mobiion;

import com.mobiion.IPCamera;
import java.io.InputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class MainCanvas
extends Canvas
implements Runnable,
CommandListener {
    int width;
    int height;
    Image offScreenImage;
    Graphics ggOffScreenImage;
    Thread myThread;
    String imageURL;
    String commandURL;
    IPCamera midlet;
    boolean doLoop = true;
    Timer timer = new Timer();
    int errors = 0;
    int transform = 0;
    final int[] direction1 = new int[]{0, 2, 4, 6, 28, 29, 26, 27};
    final int[] direction2 = new int[]{4, 6, 2, 0, 26, 28, 27, 29};
    int[] direction = this.direction1;
    int repWidth;
    int repHeight;
    long receivedBytes = 0L;
    int frames = 0;
    Vector commands = new Vector();
    boolean connected = false;

    public MainCanvas(IPCamera mid, String host, String usr, String pass, String res) {
        this.midlet = mid;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.repWidth = this.width;
        this.repHeight = this.height;
        this.imageURL = "http://" + host + "/snapshot.cgi?resolution=" + res + "&user=" + usr + "&pwd=" + pass;
        this.commandURL = "http://" + host + "/decoder_control.cgi?onestep=1&user=" + usr + "&pwd=" + pass + "&command=";
        this.offScreenImage = Image.createImage((int)this.width, (int)this.height);
        this.ggOffScreenImage = this.offScreenImage.getGraphics();
        this.ggOffScreenImage.setColor(0, 0, 0);
        this.ggOffScreenImage.fillRect(0, 0, this.width, this.height);
        this.ggOffScreenImage.setColor(255, 255, 255);
        Font f = this.ggOffScreenImage.getFont();
        this.ggOffScreenImage.drawString(this.midlet.res[23], this.width / 2 - f.stringWidth(this.midlet.res[23]) / 2, this.height / 2 - f.getHeight() / 2, 0);
        this.repaint();
        if (this.height > this.width && (this.width < 120 || res.equals("8") && this.width < 320 || res.equals("32") && this.width < 640)) {
            this.transform = 5;
            this.direction = this.direction2;
            this.repWidth = this.height;
            this.repHeight = this.width;
        }
        this.myThread = new Thread(this);
        this.myThread.start();
        Thread cmdThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (MainCanvas.this.doLoop) {
                    String c = null;
                    Vector vector = MainCanvas.this.commands;
                    synchronized (vector) {
                        if (MainCanvas.this.commands.isEmpty()) {
                            try {
                                MainCanvas.this.commands.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        c = (String)MainCanvas.this.commands.elementAt(0);
                        MainCanvas.this.commands.removeElementAt(0);
                    }
                    MainCanvas.this.sendNetCommand(c);
                }
            }
        };
        cmdThread.start();
        this.addCommand(this.midlet.backCommand);
        this.addCommand(this.midlet.exitCommand);
        this.setCommandListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCommand(int c) {
        Vector vector = this.commands;
        synchronized (vector) {
            if (this.commands.size() > 3) {
                this.commands.removeElementAt(0);
            }
            this.commands.addElement(Integer.toString(c));
            this.commands.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNetCommand(String c) {
        if (c == null) {
            return;
        }
        HttpConnection httpconnection = null;
        InputStream inputstream = null;
        try {
            httpconnection = (HttpConnection)Connector.open((String)(this.commandURL + c));
            inputstream = httpconnection.openInputStream();
        }
        catch (Exception exception) {
            ++this.errors;
        }
        finally {
            try {
                inputstream.close();
            }
            catch (Exception e) {}
            try {
                httpconnection.close();
            }
            catch (Exception e) {}
        }
    }

    public void keyPressed(int code) {
        switch (this.getGameAction(code)) {
            case 1: {
                code = 50;
                break;
            }
            case 6: {
                code = 56;
                break;
            }
            case 2: {
                code = 52;
                break;
            }
            case 5: {
                code = 54;
            }
        }
        switch (code) {
            case 50: {
                this.sendCommand(this.direction[0]);
                break;
            }
            case 56: {
                this.sendCommand(this.direction[1]);
                break;
            }
            case 52: {
                this.sendCommand(this.direction[2]);
                break;
            }
            case 54: {
                this.sendCommand(this.direction[3]);
                break;
            }
            case 49: {
                this.sendCommand(this.direction[4]);
                break;
            }
            case 51: {
                this.sendCommand(this.direction[5]);
                break;
            }
            case 55: {
                this.sendCommand(this.direction[6]);
                break;
            }
            case 57: {
                this.sendCommand(this.direction[7]);
            }
        }
    }

    public void keyReleased(int code) {
        switch (this.getGameAction(code)) {
            case 1: {
                code = 50;
                break;
            }
            case 6: {
                code = 56;
                break;
            }
            case 2: {
                code = 52;
                break;
            }
            case 5: {
                code = 54;
            }
        }
        switch (code) {
            case 50: {
                this.sendCommand(this.direction[0] + 1);
                break;
            }
            case 56: {
                this.sendCommand(this.direction[1] + 1);
                break;
            }
            case 52: {
                this.sendCommand(this.direction[2] + 1);
                break;
            }
            case 54: {
                this.sendCommand(this.direction[3] + 1);
            }
        }
    }

    public void paint(Graphics g) {
        g.drawImage(this.offScreenImage, 0, 0, 0);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.midlet.backCommand) {
            this.doLoop = false;
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.midlet.camForm);
        } else if (command == this.midlet.exitCommand) {
            Alert alert = new Alert(this.midlet.res[10], this.midlet.res[11], null, AlertType.CONFIRMATION);
            Command ok = new Command(this.midlet.res[12], 4, 0);
            Command no = new Command(this.midlet.res[13], 3, 0);
            alert.addCommand(ok);
            alert.addCommand(no);
            alert.setCommandListener(new CommandListener(){

                public void commandAction(Command cmd, Displayable dis) {
                    if (cmd.getCommandType() == 4) {
                        MainCanvas.this.midlet.commandAction(MainCanvas.this.midlet.exitCommand, dis);
                    } else {
                        Display.getDisplay((MIDlet)MainCanvas.this.midlet).setCurrent((Displayable)MainCanvas.this);
                    }
                }
            });
            alert.setTimeout(-2);
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)alert);
        }
    }

    private Image resizeImage(Image src, int screenWidth, int screenHeight) {
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        if (srcWidth <= screenWidth && srcHeight <= screenHeight) {
            return src;
        }
        double srcRatio = (double)srcHeight / (double)srcWidth;
        double screenRatio = (double)screenHeight / (double)screenWidth;
        if (srcRatio > screenRatio) {
            screenWidth = (int)((double)screenHeight * (double)screenWidth / (double)screenHeight + 0.5);
        } else if (srcRatio < screenRatio) {
            screenHeight = (int)((double)screenWidth * srcRatio);
        }
        double widthRatio = (double)srcWidth / (double)screenWidth;
        double heightRatio = (double)srcHeight / (double)screenHeight;
        Image resizedImage = Image.createImage((int)screenWidth, (int)screenHeight);
        Graphics g = resizedImage.getGraphics();
        for (int y = 0; y < screenHeight; ++y) {
            for (int x = 0; x < screenWidth; ++x) {
                g.setClip(x, y, 1, 1);
                int dx = (int)((double)x * widthRatio);
                int dy = (int)((double)y * heightRatio);
                g.drawImage(src, x - dx, y - dy, 20);
            }
        }
        return resizedImage;
    }

    private String infoString() {
        int extra;
        int bytes;
        StringBuffer sb = new StringBuffer(30);
        String unit = "K";
        if (this.receivedBytes > 1000000000L) {
            unit = "G";
            bytes = (int)(this.receivedBytes / 1000000000L);
            extra = (int)(this.receivedBytes % 1000000000L);
            extra /= 10000000;
        } else if (this.receivedBytes > 1000000L) {
            unit = "M";
            bytes = (int)(this.receivedBytes / 1000000L);
            extra = (int)(this.receivedBytes % 1000000L);
            extra /= 10000;
        } else {
            bytes = (int)(this.receivedBytes / 1000L);
            extra = (int)(this.receivedBytes % 1000L);
            extra /= 10;
        }
        sb.append(this.midlet.res[20]);
        sb.append(": ");
        sb.append(this.frames);
        sb.append("  ");
        sb.append(this.midlet.res[21]);
        sb.append(": ");
        sb.append(bytes);
        sb.append('.');
        if (extra < 10) {
            sb.append('0');
        }
        sb.append(extra);
        sb.append(unit);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNewImage() {
        InputStream inputstream;
        HttpConnection conn;
        block36: {
            int code;
            block35: {
                conn = null;
                inputstream = null;
                conn = (HttpConnection)Connector.open((String)this.imageURL, (int)1, (boolean)true);
                code = conn.getResponseCode();
                if (code != 401) break block35;
                int n = 1;
                try {
                    inputstream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                return n;
            }
            if (code == 200) break block36;
            int n = 2;
            try {
                inputstream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return n;
        }
        try {
            try {
                inputstream = conn.openInputStream();
            }
            catch (Exception exp) {
                int n = 2;
                try {
                    inputstream.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                return n;
            }
            int _len = conn.getHeaderFieldInt("Content-Length", inputstream.available());
            Image image = Image.createImage((InputStream)inputstream);
            this.receivedBytes += (long)_len;
            ++this.frames;
            image = this.resizeImage(image, this.repWidth, this.repHeight);
            if (this.transform != 0) {
                Image image2 = Image.createImage((int)image.getHeight(), (int)image.getWidth());
                Graphics g = image2.getGraphics();
                g.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), this.transform, 0, 0, 0);
                image = image2;
            }
            this.ggOffScreenImage.setColor(0, 0, 0);
            this.ggOffScreenImage.fillRect(0, 0, this.width, this.height);
            this.ggOffScreenImage.drawImage(image, this.width / 2 - image.getWidth() / 2, this.height / 2 - image.getHeight() / 2, 0);
            this.ggOffScreenImage.setColor(255, 0, 0);
            Font f = this.ggOffScreenImage.getFont();
            this.ggOffScreenImage.drawString(this.infoString(), 0, this.height - f.getHeight() - 1, 0);
            this.repaint();
            int n = 0;
            return n;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            try {
                inputstream.close();
            }
            catch (Exception e) {}
            try {
                conn.close();
            }
            catch (Exception e) {}
        }
    }

    public void run() {
        int counter = 0;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!MainCanvas.this.connected && Display.getDisplay((MIDlet)MainCanvas.this.midlet).getCurrent() == MainCanvas.this) {
                    MainCanvas.this.doLoop = false;
                    Alert alert = new Alert(MainCanvas.this.midlet.res[14], MainCanvas.this.midlet.res[16], null, AlertType.ERROR);
                    Display.getDisplay((MIDlet)MainCanvas.this.midlet).setCurrent(alert, (Displayable)MainCanvas.this.midlet.camForm);
                }
            }
        });
        thread.start();
        try {
            int ret = this.getNewImage();
            this.connected = true;
            if (ret == 1) {
                Alert alert = new Alert(this.midlet.res[14], this.midlet.res[17], null, AlertType.ERROR);
                Display.getDisplay((MIDlet)this.midlet).setCurrent(alert, (Displayable)this.midlet.camForm);
                return;
            }
            if (ret == 2) {
                Alert alert = new Alert(this.midlet.res[14], this.midlet.res[16], null, AlertType.ERROR);
                Display.getDisplay((MIDlet)this.midlet).setCurrent(alert, (Displayable)this.midlet.camForm);
                return;
            }
            if (ret == 3) {
                ++this.errors;
            }
            this.timer.schedule((TimerTask)new MyTimerTask(this), 1000L, 5000L);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"LastCamera", (boolean)true, (int)0, (boolean)false);
                byte[] tmp = "".getBytes();
                for (int i = rs.getNumRecords(); i < 6; ++i) {
                    rs.addRecord(tmp, 0, tmp.length);
                }
                String str = this.midlet.hostTextField.getString();
                byte[] bytes = str.getBytes();
                rs.setRecord(1, bytes, 0, bytes.length);
                str = this.midlet.userTextField.getString();
                bytes = str.getBytes();
                rs.setRecord(2, bytes, 0, bytes.length);
                str = this.midlet.passTextField.getString();
                bytes = str.getBytes();
                rs.setRecord(3, bytes, 0, bytes.length);
                str = this.midlet.portTextField.getString();
                bytes = str.getBytes();
                rs.setRecord(4, bytes, 0, bytes.length);
                str = this.midlet.aliasTextField.getString();
                bytes = str.getBytes();
                rs.setRecord(5, bytes, 0, bytes.length);
                bytes = new byte[]{(byte)this.midlet.resolutionGroup.getSelectedIndex()};
                rs.setRecord(6, bytes, 0, bytes.length);
                rs.closeRecordStore();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (this.doLoop) {
                if (++counter % 23 == 0) {
                    System.gc();
                }
                this.errors = 0 != this.getNewImage() ? ++this.errors : 0;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (this.errors <= 23) continue;
                Alert alert = new Alert(this.midlet.res[14], this.midlet.res[16], null, AlertType.ERROR);
                Display.getDisplay((MIDlet)this.midlet).setCurrent(alert, (Displayable)this.midlet.camForm);
                break;
            }
        }
        catch (Exception exception) {
            this.midlet.ShowException("Paint Thread", exception.toString(), true);
        }
        this.connected = true;
        this.timer.cancel();
    }

    class MyTimerTask
    extends TimerTask {
        int frames;
        MainCanvas man;
        long time;

        public MyTimerTask(MainCanvas m) {
            this.man = m;
            this.frames = this.man.frames;
            this.time = System.currentTimeMillis();
        }

        public void run() {
            long now = System.currentTimeMillis();
            int currFrames = this.man.frames;
            int timeDelta = (int)(now - this.time);
            int delta = currFrames - this.frames;
            this.frames = currFrames;
            this.time = now;
            if (this.man.midlet.lightControl != null) {
                try {
                    this.man.midlet.lightControl.setLight();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
    }
}

